/*
 * Decompiled with CFR 0.152.
 */
package org.bukkit.craftbukkit.v1_18_R2.inventory;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import org.apache.commons.lang3.Validate;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.serialization.DelegateDeserialization;
import org.bukkit.craftbukkit.v1_18_R2.enchantments.CraftEnchantment;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaArmorStand;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaAxolotlBucket;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBanner;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBlockState;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBook;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBookSigned;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaBundle;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaCharge;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaCompass;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaCrossbow;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaEnchantedBook;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaEntityTag;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaFirework;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaItem;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaKnowledgeBook;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaLeatherArmor;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaMap;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaPotion;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaSkull;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaSpawnEgg;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaSuspiciousStew;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftMetaTropicalFishBucket;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftLegacy;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftMagicNumbers;
import org.bukkit.craftbukkit.v1_18_R2.util.CraftNamespacedKey;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.material.MaterialData;

@DelegateDeserialization(value=ItemStack.class)
public final class CraftItemStack
extends ItemStack {
    net.minecraft.world.item.ItemStack handle;

    public static net.minecraft.world.item.ItemStack asNMSCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return stack.handle == null ? net.minecraft.world.item.ItemStack.f_41583_ : stack.handle.m_41777_();
        }
        if (original == null || original.getType() == Material.AIR) {
            return net.minecraft.world.item.ItemStack.f_41583_;
        }
        Item item = CraftMagicNumbers.getItem(original.getType(), original.getDurability());
        if (item == null) {
            return net.minecraft.world.item.ItemStack.f_41583_;
        }
        net.minecraft.world.item.ItemStack stack = new net.minecraft.world.item.ItemStack((ItemLike)item, original.getAmount());
        if (original.hasItemMeta()) {
            CraftItemStack.setItemMeta(stack, original.getItemMeta());
        }
        return stack;
    }

    public static net.minecraft.world.item.ItemStack copyNMSStack(net.minecraft.world.item.ItemStack original, int amount) {
        net.minecraft.world.item.ItemStack stack = original.m_41777_();
        stack.m_41764_(amount);
        return stack;
    }

    public static ItemStack asBukkitCopy(net.minecraft.world.item.ItemStack original) {
        if (original.m_41619_()) {
            return new ItemStack(Material.AIR);
        }
        ItemStack stack = new ItemStack(CraftMagicNumbers.getMaterial(original.m_41720_()), original.m_41613_());
        if (CraftItemStack.hasItemMeta(original)) {
            stack.setItemMeta(CraftItemStack.getItemMeta(original));
        }
        return stack;
    }

    public static CraftItemStack asCraftMirror(net.minecraft.world.item.ItemStack original) {
        return new CraftItemStack(original == null || original.m_41619_() ? null : original);
    }

    public static CraftItemStack asCraftCopy(ItemStack original) {
        if (original instanceof CraftItemStack) {
            CraftItemStack stack = (CraftItemStack)original;
            return new CraftItemStack(stack.handle == null ? null : stack.handle.m_41777_());
        }
        return new CraftItemStack(original);
    }

    public static CraftItemStack asNewCraftStack(Item item) {
        return CraftItemStack.asNewCraftStack(item, 1);
    }

    public static CraftItemStack asNewCraftStack(Item item, int amount) {
        return new CraftItemStack(CraftMagicNumbers.getMaterial(item), amount, 0, null);
    }

    private CraftItemStack(net.minecraft.world.item.ItemStack item) {
        this.handle = item;
    }

    private CraftItemStack(ItemStack item) {
        this(item.getType(), item.getAmount(), item.getDurability(), item.hasItemMeta() ? item.getItemMeta() : null);
    }

    private CraftItemStack(Material type, int amount, short durability, ItemMeta itemMeta) {
        this.setType(type);
        this.setAmount(amount);
        this.setDurability(durability);
        this.setItemMeta(itemMeta);
    }

    @Override
    public MaterialData getData() {
        return this.handle != null ? CraftMagicNumbers.getMaterialData(this.handle.m_41720_()) : super.getData();
    }

    @Override
    public Material getType() {
        return this.handle != null ? CraftMagicNumbers.getMaterial(this.handle.m_41720_()) : Material.AIR;
    }

    @Override
    public void setType(Material type) {
        if (this.getType() == type) {
            return;
        }
        if (type == Material.AIR) {
            this.handle = null;
        } else if (CraftMagicNumbers.getItem(type) == null) {
            this.handle = null;
        } else if (this.handle == null) {
            this.handle = new net.minecraft.world.item.ItemStack((ItemLike)CraftMagicNumbers.getItem(type), 1);
        } else {
            this.handle.setItem(CraftMagicNumbers.getItem(type));
            if (this.hasItemMeta()) {
                CraftItemStack.setItemMeta(this.handle, CraftItemStack.getItemMeta(this.handle));
            }
        }
        this.setData(null);
    }

    @Override
    public int getAmount() {
        return this.handle != null ? this.handle.m_41613_() : 0;
    }

    @Override
    public void setAmount(int amount) {
        if (this.handle == null) {
            return;
        }
        this.handle.m_41764_(amount);
        if (amount == 0) {
            this.handle = null;
        }
    }

    @Override
    public void setDurability(short durability) {
        if (this.handle != null) {
            this.handle.m_41721_((int)durability);
        }
    }

    @Override
    public short getDurability() {
        if (this.handle != null) {
            return (short)this.handle.m_41773_();
        }
        return -1;
    }

    @Override
    public int getMaxStackSize() {
        return this.handle == null ? Material.AIR.getMaxStackSize() : this.handle.m_41720_().m_41459_();
    }

    @Override
    public void addUnsafeEnchantment(org.bukkit.enchantments.Enchantment ench, int level) {
        Validate.notNull((Object)ench, (String)"Cannot add null enchantment", (Object[])new Object[0]);
        if (!CraftItemStack.makeTag(this.handle)) {
            return;
        }
        ListTag list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            list = new ListTag();
            this.handle.m_41783_().m_128365_(CraftMetaItem.ENCHANTMENTS.NBT, (Tag)list);
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = (CompoundTag)list.get(i);
            String id = tag.m_128461_(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (!ench.getKey().equals(NamespacedKey.fromString(id))) continue;
            tag.m_128376_(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
            return;
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128359_(CraftMetaItem.ENCHANTMENTS_ID.NBT, ench.getKey().toString());
        tag.m_128376_(CraftMetaItem.ENCHANTMENTS_LVL.NBT, (short)level);
        list.add((Object)tag);
    }

    static boolean makeTag(net.minecraft.world.item.ItemStack item) {
        if (item == null) {
            return false;
        }
        if (item.m_41783_() == null) {
            item.m_41751_(new CompoundTag());
        }
        return true;
    }

    @Override
    public boolean containsEnchantment(org.bukkit.enchantments.Enchantment ench) {
        return this.getEnchantmentLevel(ench) > 0;
    }

    @Override
    public int getEnchantmentLevel(org.bukkit.enchantments.Enchantment ench) {
        Validate.notNull((Object)ench, (String)"Cannot find null enchantment", (Object[])new Object[0]);
        if (this.handle == null) {
            return 0;
        }
        return EnchantmentHelper.m_44843_((Enchantment)CraftEnchantment.getRaw(ench), (net.minecraft.world.item.ItemStack)this.handle);
    }

    @Override
    public int removeEnchantment(org.bukkit.enchantments.Enchantment ench) {
        int i;
        Validate.notNull((Object)ench, (String)"Cannot remove null enchantment", (Object[])new Object[0]);
        ListTag list = CraftItemStack.getEnchantmentList(this.handle);
        if (list == null) {
            return 0;
        }
        int index = Integer.MIN_VALUE;
        int level = Integer.MIN_VALUE;
        int size = list.size();
        for (i = 0; i < size; ++i) {
            CompoundTag enchantment = (CompoundTag)list.get(i);
            String id = enchantment.m_128461_(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            if (!ench.getKey().equals(NamespacedKey.fromString(id))) continue;
            index = i;
            level = 0xFFFF & enchantment.m_128448_(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            break;
        }
        if (index == Integer.MIN_VALUE) {
            return 0;
        }
        if (size == 1) {
            this.handle.m_41783_().m_128473_(CraftMetaItem.ENCHANTMENTS.NBT);
            if (this.handle.m_41783_().m_128456_()) {
                this.handle.m_41751_(null);
            }
            return level;
        }
        ListTag listCopy = new ListTag();
        for (i = 0; i < size; ++i) {
            if (i == index) continue;
            listCopy.add((Object)list.get(i));
        }
        this.handle.m_41783_().m_128365_(CraftMetaItem.ENCHANTMENTS.NBT, (Tag)listCopy);
        return level;
    }

    @Override
    public Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments() {
        return CraftItemStack.getEnchantments(this.handle);
    }

    static Map<org.bukkit.enchantments.Enchantment, Integer> getEnchantments(net.minecraft.world.item.ItemStack item) {
        ListTag list;
        ListTag listTag = list = item != null && item.m_41793_() ? item.m_41785_() : null;
        if (list == null || list.size() == 0) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (int i = 0; i < list.size(); ++i) {
            String id = ((CompoundTag)list.get(i)).m_128461_(CraftMetaItem.ENCHANTMENTS_ID.NBT);
            int level = 0xFFFF & ((CompoundTag)list.get(i)).m_128448_(CraftMetaItem.ENCHANTMENTS_LVL.NBT);
            org.bukkit.enchantments.Enchantment enchant = org.bukkit.enchantments.Enchantment.getByKey(CraftNamespacedKey.fromStringOrNull(id));
            if (enchant == null) continue;
            result.put((Object)enchant, (Object)level);
        }
        return result.build();
    }

    static ListTag getEnchantmentList(net.minecraft.world.item.ItemStack item) {
        return item != null && item.m_41793_() ? item.m_41785_() : null;
    }

    @Override
    public CraftItemStack clone() {
        CraftItemStack itemStack = (CraftItemStack)super.clone();
        if (this.handle != null) {
            itemStack.handle = this.handle.m_41777_();
        }
        return itemStack;
    }

    @Override
    public ItemMeta getItemMeta() {
        return CraftItemStack.getItemMeta(this.handle);
    }

    public static ItemMeta getItemMeta(net.minecraft.world.item.ItemStack item) {
        if (!CraftItemStack.hasItemMeta(item)) {
            ItemMeta meta = CraftItemFactory.instance().getItemMeta(CraftItemStack.getType(item));
            ((CraftMetaItem)meta).setForgeCaps(item.getForgeCaps());
            return meta;
        }
        CraftMetaItem meta = switch (CraftItemStack.getType(item)) {
            case Material.WRITTEN_BOOK -> new CraftMetaBookSigned(item.m_41783_());
            case Material.WRITABLE_BOOK -> new CraftMetaBook(item.m_41783_());
            case Material.CREEPER_HEAD, Material.CREEPER_WALL_HEAD, Material.DRAGON_HEAD, Material.DRAGON_WALL_HEAD, Material.PLAYER_HEAD, Material.PLAYER_WALL_HEAD, Material.SKELETON_SKULL, Material.SKELETON_WALL_SKULL, Material.WITHER_SKELETON_SKULL, Material.WITHER_SKELETON_WALL_SKULL, Material.ZOMBIE_HEAD, Material.ZOMBIE_WALL_HEAD -> new CraftMetaSkull(item.m_41783_());
            case Material.LEATHER_HELMET, Material.LEATHER_HORSE_ARMOR, Material.LEATHER_CHESTPLATE, Material.LEATHER_LEGGINGS, Material.LEATHER_BOOTS -> new CraftMetaLeatherArmor(item.m_41783_());
            case Material.POTION, Material.SPLASH_POTION, Material.LINGERING_POTION, Material.TIPPED_ARROW -> new CraftMetaPotion(item.m_41783_());
            case Material.FILLED_MAP -> new CraftMetaMap(item.m_41783_());
            case Material.FIREWORK_ROCKET -> new CraftMetaFirework(item.m_41783_());
            case Material.FIREWORK_STAR -> new CraftMetaCharge(item.m_41783_());
            case Material.ENCHANTED_BOOK -> new CraftMetaEnchantedBook(item.m_41783_());
            case Material.BLACK_BANNER, Material.BLACK_WALL_BANNER, Material.BLUE_BANNER, Material.BLUE_WALL_BANNER, Material.BROWN_BANNER, Material.BROWN_WALL_BANNER, Material.CYAN_BANNER, Material.CYAN_WALL_BANNER, Material.GRAY_BANNER, Material.GRAY_WALL_BANNER, Material.GREEN_BANNER, Material.GREEN_WALL_BANNER, Material.LIGHT_BLUE_BANNER, Material.LIGHT_BLUE_WALL_BANNER, Material.LIGHT_GRAY_BANNER, Material.LIGHT_GRAY_WALL_BANNER, Material.LIME_BANNER, Material.LIME_WALL_BANNER, Material.MAGENTA_BANNER, Material.MAGENTA_WALL_BANNER, Material.ORANGE_BANNER, Material.ORANGE_WALL_BANNER, Material.PINK_BANNER, Material.PINK_WALL_BANNER, Material.PURPLE_BANNER, Material.PURPLE_WALL_BANNER, Material.RED_BANNER, Material.RED_WALL_BANNER, Material.WHITE_BANNER, Material.WHITE_WALL_BANNER, Material.YELLOW_BANNER, Material.YELLOW_WALL_BANNER -> new CraftMetaBanner(item.m_41783_());
            case Material.AXOLOTL_SPAWN_EGG, Material.BAT_SPAWN_EGG, Material.BEE_SPAWN_EGG, Material.BLAZE_SPAWN_EGG, Material.CAT_SPAWN_EGG, Material.CAVE_SPIDER_SPAWN_EGG, Material.CHICKEN_SPAWN_EGG, Material.COD_SPAWN_EGG, Material.COW_SPAWN_EGG, Material.CREEPER_SPAWN_EGG, Material.DOLPHIN_SPAWN_EGG, Material.DONKEY_SPAWN_EGG, Material.DROWNED_SPAWN_EGG, Material.ELDER_GUARDIAN_SPAWN_EGG, Material.ENDERMAN_SPAWN_EGG, Material.ENDERMITE_SPAWN_EGG, Material.EVOKER_SPAWN_EGG, Material.FOX_SPAWN_EGG, Material.GHAST_SPAWN_EGG, Material.GLOW_SQUID_SPAWN_EGG, Material.GOAT_SPAWN_EGG, Material.GUARDIAN_SPAWN_EGG, Material.HOGLIN_SPAWN_EGG, Material.HORSE_SPAWN_EGG, Material.HUSK_SPAWN_EGG, Material.LLAMA_SPAWN_EGG, Material.MAGMA_CUBE_SPAWN_EGG, Material.MOOSHROOM_SPAWN_EGG, Material.MULE_SPAWN_EGG, Material.OCELOT_SPAWN_EGG, Material.PANDA_SPAWN_EGG, Material.PARROT_SPAWN_EGG, Material.PHANTOM_SPAWN_EGG, Material.PIGLIN_BRUTE_SPAWN_EGG, Material.PIGLIN_SPAWN_EGG, Material.PIG_SPAWN_EGG, Material.PILLAGER_SPAWN_EGG, Material.POLAR_BEAR_SPAWN_EGG, Material.PUFFERFISH_SPAWN_EGG, Material.RABBIT_SPAWN_EGG, Material.RAVAGER_SPAWN_EGG, Material.SALMON_SPAWN_EGG, Material.SHEEP_SPAWN_EGG, Material.SHULKER_SPAWN_EGG, Material.SILVERFISH_SPAWN_EGG, Material.SKELETON_HORSE_SPAWN_EGG, Material.SKELETON_SPAWN_EGG, Material.SLIME_SPAWN_EGG, Material.SPIDER_SPAWN_EGG, Material.SQUID_SPAWN_EGG, Material.STRAY_SPAWN_EGG, Material.STRIDER_SPAWN_EGG, Material.TRADER_LLAMA_SPAWN_EGG, Material.TROPICAL_FISH_SPAWN_EGG, Material.TURTLE_SPAWN_EGG, Material.VEX_SPAWN_EGG, Material.VILLAGER_SPAWN_EGG, Material.VINDICATOR_SPAWN_EGG, Material.WANDERING_TRADER_SPAWN_EGG, Material.WITCH_SPAWN_EGG, Material.WITHER_SKELETON_SPAWN_EGG, Material.WOLF_SPAWN_EGG, Material.ZOGLIN_SPAWN_EGG, Material.ZOMBIE_HORSE_SPAWN_EGG, Material.ZOMBIE_SPAWN_EGG, Material.ZOMBIE_VILLAGER_SPAWN_EGG, Material.ZOMBIFIED_PIGLIN_SPAWN_EGG -> new CraftMetaSpawnEgg(item.m_41783_());
            case Material.ARMOR_STAND -> new CraftMetaArmorStand(item.m_41783_());
            case Material.KNOWLEDGE_BOOK -> new CraftMetaKnowledgeBook(item.m_41783_());
            case Material.FURNACE, Material.CHEST, Material.TRAPPED_CHEST, Material.JUKEBOX, Material.DISPENSER, Material.DROPPER, Material.ACACIA_SIGN, Material.ACACIA_WALL_SIGN, Material.BIRCH_SIGN, Material.BIRCH_WALL_SIGN, Material.CRIMSON_SIGN, Material.CRIMSON_WALL_SIGN, Material.DARK_OAK_SIGN, Material.DARK_OAK_WALL_SIGN, Material.JUNGLE_SIGN, Material.JUNGLE_WALL_SIGN, Material.OAK_SIGN, Material.OAK_WALL_SIGN, Material.SPRUCE_SIGN, Material.SPRUCE_WALL_SIGN, Material.WARPED_SIGN, Material.WARPED_WALL_SIGN, Material.SPAWNER, Material.BREWING_STAND, Material.ENCHANTING_TABLE, Material.COMMAND_BLOCK, Material.REPEATING_COMMAND_BLOCK, Material.CHAIN_COMMAND_BLOCK, Material.BEACON, Material.DAYLIGHT_DETECTOR, Material.HOPPER, Material.COMPARATOR, Material.SHIELD, Material.STRUCTURE_BLOCK, Material.SHULKER_BOX, Material.WHITE_SHULKER_BOX, Material.ORANGE_SHULKER_BOX, Material.MAGENTA_SHULKER_BOX, Material.LIGHT_BLUE_SHULKER_BOX, Material.YELLOW_SHULKER_BOX, Material.LIME_SHULKER_BOX, Material.PINK_SHULKER_BOX, Material.GRAY_SHULKER_BOX, Material.LIGHT_GRAY_SHULKER_BOX, Material.CYAN_SHULKER_BOX, Material.PURPLE_SHULKER_BOX, Material.BLUE_SHULKER_BOX, Material.BROWN_SHULKER_BOX, Material.GREEN_SHULKER_BOX, Material.RED_SHULKER_BOX, Material.BLACK_SHULKER_BOX, Material.ENDER_CHEST, Material.BARREL, Material.BELL, Material.BLAST_FURNACE, Material.CAMPFIRE, Material.SOUL_CAMPFIRE, Material.JIGSAW, Material.LECTERN, Material.SMOKER, Material.BEEHIVE, Material.BEE_NEST, Material.SCULK_SENSOR -> new CraftMetaBlockState(item.m_41783_(), CraftMagicNumbers.getMaterial(item.m_41720_()));
            case Material.TROPICAL_FISH_BUCKET -> new CraftMetaTropicalFishBucket(item.m_41783_());
            case Material.AXOLOTL_BUCKET -> new CraftMetaAxolotlBucket(item.m_41783_());
            case Material.CROSSBOW -> new CraftMetaCrossbow(item.m_41783_());
            case Material.SUSPICIOUS_STEW -> new CraftMetaSuspiciousStew(item.m_41783_());
            case Material.COD_BUCKET, Material.PUFFERFISH_BUCKET, Material.SALMON_BUCKET, Material.ITEM_FRAME, Material.GLOW_ITEM_FRAME, Material.PAINTING -> new CraftMetaEntityTag(item.m_41783_());
            case Material.COMPASS -> new CraftMetaCompass(item.m_41783_());
            case Material.BUNDLE -> new CraftMetaBundle(item.m_41783_());
            default -> new CraftMetaItem(item.m_41783_());
        };
        CompoundTag tag = item.m_41783_();
        if (tag != null) {
            meta.offerUnhandledTags(tag);
        }
        meta.setForgeCaps(item.getForgeCaps());
        return meta;
    }

    static Material getType(net.minecraft.world.item.ItemStack item) {
        return item == null ? Material.AIR : CraftMagicNumbers.getMaterial(item.m_41720_());
    }

    @Override
    public boolean setItemMeta(ItemMeta itemMeta) {
        return CraftItemStack.setItemMeta(this.handle, itemMeta);
    }

    public static boolean setItemMeta(net.minecraft.world.item.ItemStack item, ItemMeta itemMeta) {
        Item newItem;
        if (item == null) {
            return false;
        }
        if (CraftItemFactory.instance().equals(itemMeta, null)) {
            item.m_41751_(null);
            return true;
        }
        if (!CraftItemFactory.instance().isApplicable(itemMeta, CraftItemStack.getType(item))) {
            return false;
        }
        itemMeta = CraftItemFactory.instance().asMetaFor(itemMeta, CraftItemStack.getType(item));
        if (itemMeta == null) {
            return true;
        }
        Item oldItem = item.m_41720_();
        if (oldItem != (newItem = CraftMagicNumbers.getItem(CraftItemFactory.instance().updateMaterial(itemMeta, CraftMagicNumbers.getMaterial(oldItem))))) {
            item.setItem(newItem);
        }
        CompoundTag tag = new CompoundTag();
        item.m_41751_(tag);
        ((CraftMetaItem)itemMeta).applyToItem(tag);
        item.convertStack(((CraftMetaItem)itemMeta).getVersion());
        CompoundTag forgeCaps = ((CraftMetaItem)itemMeta).getForgeCaps();
        if (forgeCaps != null) {
            item.setForgeCaps(forgeCaps);
        }
        if (item.m_41720_() != null && item.m_41720_().m_41465_()) {
            item.m_41721_(item.m_41773_());
        }
        return true;
    }

    @Override
    public boolean isSimilar(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (stack == this) {
            return true;
        }
        if (!(stack instanceof CraftItemStack)) {
            return stack.getClass() == ItemStack.class && stack.isSimilar(this);
        }
        CraftItemStack that = (CraftItemStack)stack;
        if (this.handle == that.handle) {
            return true;
        }
        if (this.handle == null || that.handle == null) {
            return false;
        }
        Material comparisonType = CraftLegacy.fromLegacy(that.getType());
        if (comparisonType != this.getType() || this.getDurability() != that.getDurability()) {
            return false;
        }
        return this.hasItemMeta() ? that.hasItemMeta() && Objects.equals(this.handle.m_41783_(), that.handle.m_41783_()) && Objects.equals(this.handle.getForgeCaps(), that.handle.getForgeCaps()) : !that.hasItemMeta();
    }

    @Override
    public boolean hasItemMeta() {
        return CraftItemStack.hasItemMeta(this.handle) && !CraftItemFactory.instance().equals(this.getItemMeta(), null);
    }

    static boolean hasItemMeta(net.minecraft.world.item.ItemStack item) {
        CompoundTag forgeCaps;
        if (item != null && (forgeCaps = item.getForgeCaps()) != null && !forgeCaps.m_128456_()) {
            return true;
        }
        return item != null && item.m_41783_() != null && !item.m_41783_().m_128456_();
    }
}

